/* Trang web Đại Tạng Kinh được lập trình bởi Xuân Duật và đây là mã nguồn mở */

var sound = document.createElement('audio');
var soundIndex = null, soundType = 'Any', sounddatas = null, soundVisualizer = Math.round(Math.random());
var audioCTX = null, analyser = null;

var ogvplaying = false;
var ogvplayer = null;

function soundcall(index, type)
{
	if(soundIndex == index)
	{
		if((ogvplaying && ogvplayer.paused) || (!ogvplaying && sound.paused)) soundplay();
		else soundpause();
		if(type == soundType) return;
	}

	if(soundIndex != null)
	{
		if(soundType == 'Any') 
		{
			innerHTML('soundAny_' + soundIndex, '►');
			innerHTML('soundAnyt_' + soundIndex, '');
			innerHTML('soundAnyp_' + soundIndex, '');
		}
		else
		{
			innerHTML('sound' + soundType + '_' + soundIndex, '►');
			innerHTML('sound' + soundType + 't_' + soundIndex, '');
			innerHTML('sound' + soundType + 'p_' + soundIndex, '');
		}
	}
	
	soundclear();
	
	soundIndex = index;
	soundType = type;
	ogvplaying = false;
	
	innerHTML('sound' + soundType + 't_' + soundIndex, '<span id=timer></span> &nbsp; <span id=mode></span>');
	innerHTML('sound' + soundType + 'p_' + soundIndex, '<div style="padding-top: 0px; padding-bottom: 10px;">' + (window.AudioContext ? '<div onclick="soundvisual();"><canvas id=spectrum></canvas></div>':'') + '<div id=scrubber style="cursor:pointer; border:1px solid #CFDFEF; border-radius: 4px; height: 7px; width: auto;"><div id=progress style="border-radius: 4px; height: 7px; width: 0px; background: #5B91C8; z-index: 1;"></div></div></div>');
	obj('scrubber').addEventListener('click', soundscrubbing);
	
	sound.addEventListener('ended', soundended);
	sound.addEventListener('timeupdate', soundtimeupdate);
	
	var data_src = obj('sound' + soundType + '_' + index).getAttribute('data-src');
	var a = data_src.split("|");
	var mp3exist = false;
	var oggexist = false;
	var mp3file = '';
	var oggfile = ''
	var file = '';
	if(a.length == 2)
	{
		mp3exist = true;
		oggexist = true;
		mp3file = a[0];
		oggfile = a[1];
	}
	else if(a.length == 1)
	{
		var tmp = a[0].substr(-3);
		if(tmp.toLowerCase() == 'mp3')
		{
			mp3exist = true;
			mp3file = a[0];
		}
		else if(tmp.toLowerCase() == 'ogg')
		{
			oggexist = true;
			oggfile = a[0];
		}
	}
	if(audioType == 'ogg' && oggexist) file = oggfile;
	else if(audioType == 'mp3' && oggexist && !mp3exist)
	{
		file = data_src;
		loadScript('a/module/ogvjs/ogv.js', 'soundogvplayer("'+file+'");');
	}
	else if(mp3exist) file = mp3file;
	else file = data_src;
	
	sound.src = file;
	soundplay();
	soundmode();
    if(window.AudioContext) soundrender();
}
function soundogvplayer(file)
{
	ogvplaying = true;
	ogvplayer = new OGVPlayer();
	ogvplayer.addEventListener('ended', function(){ soundended();});
	ogvplayer.addEventListener('timeupdate', function()
	{
		innerHTML('timer', ' &nbsp; <span class=sanskrit>' + formatTime(ogvplayer.currentTime) + ' / ' + formatTime(ogvplayer.duration) + '</span>');
		//obj('progress').style.width = Math.round(ogvplayer.currentTime/ogvplayer.duration * 100) + '%';
	});
	
	document.getElementById('sound' + soundType + 'p_' + soundIndex).appendChild(ogvplayer);
	ogvplayer.src = file;
	ogvplayer.play();
	hide('sound' + soundType + 'p_' + soundIndex);
}
function soundended()
{
	setTimeout(soundnext, 500);
}
function soundtimeupdate()
{
	innerHTML('timer', ' &nbsp; <span class=sanskrit>' + formatTime(sound.currentTime) + ' / ' + formatTime(sound.duration) + '</span>');
	obj('progress').style.width = Math.round(sound.currentTime/sound.duration * 100) + '%';
}
function soundrender()
{
	if(soundVisualizer == 0) soundbar();
	else
	{
		soundupdate();
		soundspectrum();
	}
    startAnimation(soundrender);
}
function soundbar()
{
	var bufferLength = analyser.frequencyBinCount;
	var dataArray = new Uint8Array(bufferLength);
	
	analyser.getByteFrequencyData(dataArray);
	
	var height = 100;
	var o = obj('spectrum');
	var ctx = o.getContext('2d');
	o.width = obj('scrubber').getBoundingClientRect().width;
	o.height = height;
    ctx.clearRect(0, 0, o.width, o.height);
	
	var barWidth = (o.width / bufferLength) * 2.5;
	var barHeight;
	var x = 0;
	for(var i = 0; i < bufferLength; i++)
	{
		barHeight = dataArray[i];
		ctx.fillStyle = 'rgb(255,128,' + i + ')';
		ctx.fillRect(x, height - barHeight/2, barWidth, barHeight/2);
		x += barWidth + 1;
	}
}
function soundupdate()
{
	var a = new Uint8Array(analyser.frequencyBinCount);
	analyser.getByteFrequencyData(a);
    if(sounddatas == null)
	{
        sounddatas = [];
        for(var i = 0; i < a.length; i++)
			sounddatas[i] = a[i];
    }
    for(var i = 0; i < a.length; i++)
		sounddatas[i] += (a[i] - sounddatas[i]) * .1;
}
function soundspectrum()
{
	var step = 5;
	var o = obj('spectrum');
	var ctx = o.getContext('2d');
	o.width = obj('scrubber').getBoundingClientRect().width;
	o.height = 100;
    ctx.clearRect(0, 0, o.width, o.height);
	
    for(var i = 0; i < sounddatas.length; i++)
	{
        var v = 0;
		for(var j = i; j < i+step; j++ )
			v += sounddatas[j];
		v /= i+step-i;
        ctx.fillStyle = 'rgb(255,128,' + i + ')';
        ctx.beginPath();
        ctx.fillRect(256*2 - i*2, o.height, step, - v * o.height / 256);
        ctx.fillRect(i*2 + 256*2, o.height, step, - v * o.height / 256);
    }
}
function soundmode()
{
	var mode = localStorage.getItem('soundmode');
	var playall = mode == null || mode == 'playall' ? 'nav bright' : 'nav';
	var repeat =  mode == 'repeat' ? 'nav bright' : 'nav';
	var shuffle =  mode == 'shuffle' ? 'nav bright' : 'nav';
	var s = '';
	var lang = readCookie('l') == 'en' ? 'en':'vi';

	s += '<sup><a class="' + playall + '" href="javascript:void(0);" onclick="soundmodeset(\'playall\'); return false;"><span title="' + (lang == 'en' ? 'Sequential':'Thứ tự') + '" style="position: relative;">⏭️</span></a>';
	s += '<a class="' + repeat + '" href="javascript:void(0);" onclick="soundmodeset(\'repeat\'); return false;"><span title="' + (lang == 'en' ? 'Repeat':'Lặp lại') +  '" style="position: relative;">🔁</span></a>';
	s += '<a class="' + shuffle + '" href="javascript:void(0);" onclick="soundmodeset(\'shuffle\'); return false;"><span title="' + (lang == 'en' ? 'Shuffle':'Xáo trộn') + '" style="position: relative;">🔀</span></a></sup>';

	innerHTML('mode', s);
}
function soundmodeset(mode)
{
	localStorage.setItem('soundmode', mode);
	soundmode();
}
function soundscrubbing(e) 
{
    var parentPos = getPosition(e.currentTarget);
    var xPos = e.clientX - parentPos.x;
	
	if(ogvplaying)
	{
		//not working correctly
		//console.log(ogvplayer.currentTime + ' -------  ' + ogvplayer.duration + ' -------  ' + ogvplayer.duration * (xPos / obj('scrubber').offsetWidth));
		//ogvplayer.currentTime = ogvplayer.duration * (xPos / obj('scrubber').offsetWidth);
	}
	else sound.currentTime = sound.duration * (xPos / obj('scrubber').offsetWidth);
}
function soundclear()
{
	if(audioCTX == null)
	{
		audioCTX = new AudioContext();
		analyser = audioCTX.createAnalyser();
		audioCTX.createMediaElementSource(sound).connect(analyser);
		analyser.fftSize = 512;
		analyser.connect(audioCTX.destination);
	}
	
	if(soundIndex == null) return;
	sound.pause();
	sound.removeEventListener('ended', soundended);
	sound.removeEventListener('timeupdate', soundtimeupdate);
	soundIndex = null;
	stopAnimation();
}
function soundplay()
{
	innerHTML('sound' + soundType + '_' + soundIndex, '&nbsp;ll&nbsp;');
	if(ogvplaying) ogvplayer.play();
	else sound.play();
}
function soundpause()
{
	innerHTML('sound' + soundType + '_' + soundIndex, '►');
	if(ogvplaying) ogvplayer.pause();
	else sound.pause();
}
function soundnext()
{
	var mode = localStorage.getItem('soundmode');
	if(mode == 'repeat')
	{
		sound.currTime = 0;
		sound.play();
	}
	else if(mode == 'shuffle')
	{
		var n = 0;
		var val = true;
		while(val || n > 1000)
		{
			if(elementExist('sound' + soundType + '_' + n)) n++;
			else
			{
				val = false;
				break;
			}
		}
		soundcall(Math.floor((Math.random() * n)), soundType);
		soundscroll();
	}
	else
	{
		if(elementExist('sound' + soundType + '_' + (soundIndex + 1))) soundcall(soundIndex + 1, soundType);
		else soundcall(0, soundType);
		soundscroll();
	}
}
function soundscroll()
{
	var o = obj('sound' + soundType + '_' + soundIndex);
	if(!isElementInViewport(o)) o.scrollIntoView();
}
function soundvisual(){ soundVisualizer = soundVisualizer ? 0:1;}